const endpoint = '/follow_handler';
// Total re-render of follow links / me spans
function update_follow_links(my_pk, following, server_url = '') {
    const follow_icon = bsi('person_plus'), following_icon = bsi('person_check');
    try {
        $('.follow-link-processing-done').removeClass('follow-link-processing-done'); // Used for cloning follow links on new chats.
        $('.user-profile-link').each(function() {
            // Prevent redundant rendering of follow links / me spans
            const directParent = $(this).parent();
            directParent.find('.follow-btn').remove();
            directParent.find('.me-span').remove();
            // Render follow links / me spans
            const public_key = $(this).data('public-key');
            if (public_key == my_pk) { // This is me
                const me_span = $(`<span class="text text-muted small me-span" style="padding-left:6px;" data-public-key="${my_pk}">me</span>`);
                $(this).after(me_span);
                $(this).addClass('me');
                return;
            } // not me
            const is_following = following.includes(public_key);
            const link_text = is_following ? following_icon : '<span class="small"><span class="small">follow</span></span>' + follow_icon;
            const follow_class = is_following ? '' : 'text-muted';
            const follow_link = $(`<a class="follow-btn ${follow_class}" data-public-key="${public_key}" style="padding-left:6px;">${link_text}</a>`);
            follow_link.on('click', function() {
                $(this).animate({ opacity: 0 }, 200);
                const pk = $(this).data('public-key');
                const jwt = localStorage.getItem('jwt');
                if (!jwt) {
                    return;
                }
                const headers = { 'Authorization': `Bearer ${jwt}` };
                $.ajax({
                    url: `${server_url}${endpoint}`,
                    type: 'POST',
                    headers: headers,
                    data: JSON.stringify({ public_key: pk }), // follows and/or unfollows
                    contentType: 'application/json',
                    success: function(data) {
                        update_follow_links((data?.my_pk || null), (data?.following || []));
                    }
                });
            });
            $(this).after(follow_link);
            // Tell the cloning function to skip this link
            $(this).addClass('follow-link-processing-done');
        });
    } catch (e) {
        console.error(e);
    }
}
// Server call for follow data + rendering of follow links / me spans
function init_follow_links(server_url = '') {
    const jwt = localStorage.getItem('jwt');
    if (!jwt) {
        return;
    }
    const headers = {
        'Content-Type': 'application/json',
        'Authorization': `Bearer ${jwt}`
    };
    $.ajax({
        url: `${server_url}${endpoint}`,
        type: 'GET',
        headers: headers,
        success: function(data) {
            try {
                const my_pk = data.my_pk;
                const following = data.following; // list of public keys I follow
                // render follow links / me spans
                update_follow_links(my_pk, following, server_url);
            } catch (e) {
                console.error(e);
            }
        }
    });
}
// Use this function when new chats are added dynamically via AJAX or infinite scroll.
function clone_follow_links(server_url = '') {
    const pks = []; // Public keys that require follow links or me spans
    var skipped = 0;
    // Collect public keys that require follow links or me spans
    $('.user-profile-link:not(.follow-link-processing-done)').each(function() {
        const public_key = $(this).data('public-key');
        if (public_key && !pks.includes(public_key)) {
            pks.push(public_key);
        }
    });
    // Try to find follow links or me spans from previously rendered chats
    for (const pk of pks) {
        const follow_link = $(`.follow-btn[data-public-key="${pk}"]`);
        const me_span = $(`.me-span[data-public-key="${pk}"]`);
        if (follow_link.length > 0) { // Clone follow link to profiles with the same public key that require it.
            const clone = follow_link.first().clone();
            $(`.user-profile-link[data-public-key="${pk}"]:not(.follow-link-processing-done)`).each(function() {
                if ($(this).parent().find('.follow-btn').length > 0) {
                    return;
                }
                $(this).after(clone.clone());
                $(this).addClass('follow-link-processing-done');
            });
            continue;
        }
        if (me_span.length > 0) { // Clone me span
            const clone = me_span.first().clone();
            $(`.user-profile-link[data-public-key="${pk}"]:not(.follow-link-processing-done)`).each(function() {
                if ($(this).parent().find('.me-span').length > 0) {
                    return;
                }
                $(this).after(clone.clone());
                $(this).addClass('follow-link-processing-done').addClass('me');
            });
            continue;
        }
        skipped += 1;
    }
    if (skipped > 0) {
        init_follow_links(server_url); // New users have entered the chat, get server data on them.
    }
}